package easik.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;

import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

import easik.Easik;
import easik.EasikConstants;


/** 
 * Menu action for exporting the sketch as XML
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @version 2006-07-13 Kevin Green
 */

public class FileSaveAsAction extends AbstractAction {
	
	/**
	 * Create a new save as menu action.
	 *
	 */
	public FileSaveAsAction() {
		super("Save Sketch As...");
		putValue(AbstractAction.MNEMONIC_KEY, new Integer(KeyEvent.VK_A));
		putValue(
			AbstractAction.SHORT_DESCRIPTION,
			"Export current sketch as XML document");		
	}

	/**
	 * Display a dialog prompting the user for the name under which to save the current sketch.
	 *  
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e) {
		JFileChooser saveDialog = new JFileChooser(Easik.getInstance().getIni().getDefaultFolder());
		saveDialog.addChoosableFileFilter( new XMLFileFilter() );
		saveDialog.showSaveDialog(Easik.getInstance().getFrame());
		File selFile = saveDialog.getSelectedFile();
		
		if (selFile != null) {	
			if(!selFile.getName().endsWith(EasikConstants.XML_FILE)){
				selFile = new File(selFile.getPath() + EasikConstants.XML_FILE);
			}
			Easik.getInstance().getFrame().getSketch().getDocInfo().setDateInfo();
			Easik.getInstance().getFrame().getSketch().saveToXML(selFile);
			Easik.getInstance().getFrame().getSketch().setDirty(false);			
			Easik.getInstance().getFrame().getSketch().setFile( selFile );
			Easik.getInstance().getIni().setLastUsedFolder(selFile.getAbsolutePath());
			Easik.getInstance().getIni().addRecentFile(selFile);
		}
	}
}